/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateFastAttackAction;
import com.megacrit.cardcrawl.actions.animations.ShoutAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.EscapeAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.actions.unique.SummonGremlinAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.MinionPower;
import com.megacrit.cardcrawl.powers.StrengthPower;
import java.util.ArrayList;

public class GremlinLeader
extends AbstractMonster {
    public static final String ID = "GremlinLeader";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("GremlinLeader");
    public static final String NAME = GremlinLeader.monsterStrings.NAME;
    public static final String[] MOVES = GremlinLeader.monsterStrings.MOVES;
    public static final String[] DIALOG = GremlinLeader.monsterStrings.DIALOG;
    public static final String ENC_NAME = "Gremlin Leader Combat";
    public AbstractMonster[] gremlins = new AbstractMonster[3];
    public static final float POSX1 = -366.0f;
    public static final float POSY1 = -4.0f;
    public static final float POSX2 = -170.0f;
    public static final float POSY2 = 6.0f;
    public static final float POSX3 = -532.0f;
    public static final float POSY3 = 0.0f;
    private static final byte RALLY = 2;
    private static final String RALLY_NAME = MOVES[0];
    private static final byte ENCOURAGE = 3;
    private static final int STR_AMT = 3;
    private static final int BLOCK_AMT = 6;
    private static final byte STAB = 4;
    private int STAB_DMG = 6;
    private int STAB_AMT = 3;

    public GremlinLeader() {
        super(NAME, ID, 160, 0.0f, -15.0f, 200.0f, 310.0f, "images/monsters/theCity/gremlinLeader.png", 35.0f, 0.0f);
        this.type = AbstractMonster.EnemyType.ELITE;
        this.loadAnimation("images/monsters/theCity/gremlinleader/skeleton.atlas", "images/monsters/theCity/gremlinleader/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "animation", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        e.setTimeScale(1.5f);
        this.dialogX = -80.0f * Settings.scale;
        this.dialogY = 50.0f * Settings.scale;
        this.damage.add(new DamageInfo(this, this.STAB_DMG));
    }

    @Override
    public void usePreBattleAction() {
        this.gremlins[0] = AbstractDungeon.getMonsters().monsters.get(0);
        this.gremlins[1] = AbstractDungeon.getMonsters().monsters.get(1);
        this.gremlins[2] = null;
        for (AbstractMonster m : this.gremlins) {
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, m, new MinionPower(this)));
        }
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new SummonGremlinAction(this.gremlins));
                AbstractDungeon.actionManager.addToBottom(new SummonGremlinAction(this.gremlins));
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new ShoutAction(this, this.getEncourageQuote()));
                for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                    if (m == this) {
                        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, this, new StrengthPower(m, 3), 3));
                        continue;
                    }
                    if (m.isDying) continue;
                    AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, this, new StrengthPower(m, 3), 3));
                    AbstractDungeon.actionManager.addToBottom(new GainBlockAction(m, this, 6));
                }
                break;
            }
            case 4: {
                AbstractDungeon.actionManager.addToBottom(new AnimateFastAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new WaitAction(0.2f));
                AbstractDungeon.actionManager.addToBottom(new DamageAction(AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_HORIZONTAL, true));
                AbstractDungeon.actionManager.addToBottom(new WaitAction(0.2f));
                AbstractDungeon.actionManager.addToBottom(new DamageAction(AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_VERTICAL, true));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_HEAVY));
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    private String getEncourageQuote() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DIALOG[0]);
        list.add(DIALOG[1]);
        list.add(DIALOG[2]);
        return (String)list.get(MathUtils.random(0, list.size() - 1));
    }

    @Override
    protected void getMove(int num) {
        if (this.numAliveGremlins() == 0) {
            if (num < 75) {
                if (!this.lastMove((byte)2)) {
                    this.setMove(RALLY_NAME, (byte)2, AbstractMonster.Intent.UNKNOWN);
                } else {
                    this.setMove((byte)4, AbstractMonster.Intent.ATTACK, this.STAB_DMG, this.STAB_AMT, true);
                }
            } else if (!this.lastMove((byte)4)) {
                this.setMove((byte)4, AbstractMonster.Intent.ATTACK, this.STAB_DMG, this.STAB_AMT, true);
            } else {
                this.setMove(RALLY_NAME, (byte)2, AbstractMonster.Intent.UNKNOWN);
            }
        } else if (this.numAliveGremlins() < 2) {
            if (num < 50) {
                if (!this.lastMove((byte)2)) {
                    this.setMove(RALLY_NAME, (byte)2, AbstractMonster.Intent.UNKNOWN);
                } else {
                    this.getMove(MathUtils.random(50, 99));
                }
            } else if (num < 80) {
                if (!this.lastMove((byte)3)) {
                    this.setMove((byte)3, AbstractMonster.Intent.DEFEND_BUFF);
                } else {
                    this.setMove((byte)4, AbstractMonster.Intent.ATTACK, this.STAB_DMG, this.STAB_AMT, true);
                }
            } else if (!this.lastMove((byte)4)) {
                this.setMove((byte)4, AbstractMonster.Intent.ATTACK, this.STAB_DMG, this.STAB_AMT, true);
            } else {
                this.getMove(MathUtils.random(0, 80));
            }
        } else if (this.numAliveGremlins() > 1) {
            if (num < 66) {
                if (!this.lastMove((byte)3)) {
                    this.setMove((byte)3, AbstractMonster.Intent.DEFEND_BUFF);
                } else {
                    this.setMove((byte)4, AbstractMonster.Intent.ATTACK, this.STAB_DMG, this.STAB_AMT, true);
                }
            } else if (!this.lastMove((byte)4)) {
                this.setMove((byte)4, AbstractMonster.Intent.ATTACK, this.STAB_DMG, this.STAB_AMT, true);
            } else {
                this.setMove((byte)3, AbstractMonster.Intent.DEFEND_BUFF);
            }
        }
    }

    private int numAliveGremlins() {
        int count = 0;
        for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
            if (m == null || m == this || m.isDying) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void die() {
        super.die();
        boolean first = true;
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            if (m.isDying) continue;
            if (first) {
                AbstractDungeon.actionManager.addToBottom(new ShoutAction(m, DIALOG[3], 0.5f, 1.2f));
                first = false;
                continue;
            }
            AbstractDungeon.actionManager.addToBottom(new ShoutAction(m, DIALOG[4], 0.5f, 1.2f));
        }
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            if (m.isDying) continue;
            AbstractDungeon.actionManager.addToBottom(new EscapeAction(m));
        }
    }
}

